vehicle_diameter = 0.198;
vehicle_diameter_back = 0.08106;
vehicle_length = 0.130;
tube_diameter = 10*vehicle_diameter; //1.98
tube_length = 10*vehicle_diameter; //1.98

shield_radius = 0.19;

vehicle_gridsize = 0.01*vehicle_diameter; //0.00198
far_gridsize = 0.02*tube_diameter; //0.0396

shock_grid_line_distance = vehicle_diameter/2; //0.099
shock_grid_line_length = vehicle_diameter; //0.198

// Derived variables.
shield_span = Asin(vehicle_diameter/2 / shield_radius); //31.4
shield_end_distance = (1-Cos(shield_span))*shield_radius; //0.027


Point(1) = {0,0,0,vehicle_gridsize};
Point(2) = {shield_radius,0,0,vehicle_gridsize};
Point(3) = {shield_end_distance,vehicle_diameter/2,0,vehicle_gridsize};
Point(4) = {vehicle_length,0,0,vehicle_gridsize};
Point(5) = {vehicle_length,vehicle_diameter_back/2,0,vehicle_gridsize};
Point(6) = {-tube_length/2+vehicle_length/2,0,0,far_gridsize};
Point(7) = {tube_length/2+vehicle_length/2,0,0,far_gridsize};
Point(8) = {-tube_length/2+vehicle_length/2,tube_diameter/2,0,far_gridsize};
Point(9) = {tube_length/2+vehicle_length/2,tube_diameter/2,0,far_gridsize};

Line(10) = {6,1};
Circle(11) = {1,2,3};
Line(12) = {3,5};
Line(13) = {5,2};
Line(14) = {2,7};
Line(15) = {7,9};
Line(16) = {9,8};
Line(17) = {8,6};



Field[1] = Attractor;
Field[1].NNodesByEdge = 100;
Field[1].EdgesList = {11};
Field[2] = Threshold;
Field[2].IField = 1;
Field[2].LcMin = vehicle_gridsize;
Field[2].LcMax = far_gridsize;
Field[2].DistMin = 0.4*vehicle_diameter;
Field[2].DistMax = 1*vehicle_diameter;
Field[7] = Min;
Field[7].FieldsList = {2};
Background Field = 7;




Line Loop(18) = {10:17};

Plane Surface(19) = 18;




Rotate {{1,0,0},{0,0,0},2.5*Pi/180.0}
{
	Surface{19};
}
new_entities[] = Extrude {{1,0,0},{0,0,0},-5*Pi/180.0}
{
	Surface{19};
	Layers{1};
	Recombine;
};
Physical Surface("vehicle") = {new_entities[{2:4}]};
Physical Surface("tunnel") = {new_entities[6]};
Physical Surface("outlet") = {new_entities[5]};
Physical Surface("inlet") = {new_entities[7]};
Physical Surface("wedge0") = {19};
Physical Surface("wedge1") = {new_entities[0]};

Physical Volume("volume") = {new_entities[1]};

