// Gmsh project created on Sat Dec 28 12:31:21 2019
theta=Pi/4;
s= Sin(theta);
c= Cos(theta);
//+
//CYLINDER WALL POINTS
Point(1) = {0, 0, 0, 1.0};
//+
Point(2) = {2.5/1000, 0, 0, 1.0};
//+
Point(3) = {-2.5/1000, 0, 0, 1.0};
//+
Point(4) = {0, 2.5/1000, 0, 1.0};
//+
Point(5) = {0, -2.5/1000, 0, 1.0};
//+
Point(6) = {2.5/1000*c, 2.5/1000*s, 0, 1.0};
//+
Point(7) = {2.5/1000*c, -2.5/1000*s, 0, 1.0};
//+
Point(8) = {-2.5/1000*c, -2.5/1000*s, 0, 1.0};
//+
Point(9) = {-2.5/1000*c, 2.5/1000*s, 0, 1.0};
//CYLINDER WALL OUTER MESH ZONAL POINTS
//+
Point(10) = {10*5/1000, 0, 0, 1.0};
//+
Point(11) = {-10*5/1000, 0, 0, 1.0};
//+
Point(12) = {0, 10*5/1000, 0, 1.0};
//+
Point(13) = {0, -10*5/1000, 0, 1.0};
//+
Point(14) = {10*5/1000*c, 10*5/1000*s, 0, 1.0};
//+
Point(15) = {10*5/1000*c, -10*5/1000*s, 0, 1.0};
//+
Point(16) = {-10*5/1000*c, -10*5/1000*s, 0, 1.0};
//+
Point(17) = {-10*5/1000*c, 10*5/1000*s, 0, 1.0};
//OUTER DOMAIN MESH ZONAL POINTS
//+
Point(18) = {50*5/1000, 30*5/1000, 0, 1.0};
//+
Point(19) = {50*5/1000, -30*5/1000, 0, 1.0};
//+
Point(20) = {-30*5/1000, -30*5/1000, 0, 1.0};
//+
Point(21) = {-30*5/1000, 30*5/1000, 0, 1.0};


//TOP_ZONE
//+
Point(22) = {-10*5/1000*c, 30*5/1000, 0, 1.0};
//+
Point(23) = {0, 30*5/1000, 0, 1.0};
//+
Point(24) = {10*5/1000*c, 30*5/1000, 0, 1.0};

//BOTTOM_ZONE
//+
Point(25) = {-10*5/1000*c, -30*5/1000, 0, 1.0};
//+
Point(26) = {0, -30*5/1000, 0, 1.0};
//+
Point(27) = {10*5/1000*c, -30*5/1000, 0, 1.0};

//INLET_ZONE
//+
Point(28) = {-30*5/1000, 10*5/1000*s, 0, 1.0};
//+
Point(29) = {-30*5/1000, 0, 0, 1.0};
//+
Point(30) = {-30*5/1000, -10*5/1000*s, 0, 1.0};

//OUTLET_ZONE
//+
Point(31) = {50*5/1000, 10*5/1000*s, 0, 1.0};
//+
Point(32) = {50*5/1000, 0, 0, 1.0};
//+
Point(33) = {50*5/1000, -10*5/1000*s, 0, 1.0};

//LINES&CIRCLE_FORMARTION
//+
Line(1) = {21, 28};
//+
Line(2) = {28, 29};
//+
Line(3) = {29, 30};
//+
Line(4) = {30, 20};
//+
Line(5) = {20, 25};
//+
Line(6) = {25, 26};
//+
Line(7) = {26, 27};
//+
Line(8) = {27, 19};
//+
Line(9) = {19, 33};
//+
Line(10) = {33, 32};
//+
Line(11) = {32, 31};
//+
Line(12) = {31, 18};
//+
Line(13) = {18, 24};
//+
Line(14) = {24, 23};
//+
Line(15) = {23, 22};
//+
Line(16) = {22, 21};
//+
Line(17) = {28, 17};
//+
Line(18) = {29, 11};
//+
Line(19) = {30, 16};
//+
Line(20) = {16, 25};
//+
Line(21) = {13, 26};
//+
Line(22) = {15, 27};
//+
Line(23) = {15, 13};
//+
Line(24) = {13, 16};
//+
Line(25) = {16, 11};
//+
Line(26) = {11, 17};
//+
Line(27) = {17, 12};
//+
Line(28) = {12, 14};
//+
Line(29) = {14, 10};
//+
Line(30) = {10, 15};
//+
Line(31) = {14, 31};
//+
Line(32) = {10, 32};
//+
Line(33) = {15, 33};
//+
Line(34) = {17, 22};
//+
Line(35) = {12, 23};
//+
Line(36) = {14, 24};
//+
Circle(37) = {9, 1, 4};
//+
Circle(38) = {4, 1, 6};
//+
Circle(39) = {6, 1, 2};
//+
Circle(40) = {2, 1, 7};
//+
Circle(41) = {7, 1, 5};
//+
Circle(42) = {5, 1, 8};
//+
Circle(43) = {9, 1, 3};
//+
Circle(44) = {8, 1, 3};
//+
Line(45) = {12, 4};
//+
Line(46) = {5, 13};
//+
Line(47) = {17, 9};
//+
Line(48) = {6, 14};
//+
Line(49) = {3, 11};
//+
Line(50) = {2, 10};
//+
Line(51) = {8, 16};
//+
Line(52) = {7, 15};


//SURFACES_&_TRANSFINITE
//+
Line Loop(1) = {1, 17, 34, 16};
//+
Plane Surface(1) = {1};
//+
Line Loop(2) = {2, 18, 26, -17};
//+
Plane Surface(2) = {2};
//+
Line Loop(3) = {3, 19, 25, -18};
//+
Plane Surface(3) = {3};
//+
Line Loop(4) = {4, 5, -20, -19};
//+
Plane Surface(4) = {4};
//+
Line Loop(5) = {15, -34, 27, 35};
//+
Plane Surface(5) = {5};
//+
Line Loop(6) = {26, 47, 43, 49};
//+
Plane Surface(6) = {6};
//+
Line Loop(7) = {49, -25, -51, 44};
//+
Plane Surface(7) = {7};
//+
Line Loop(8) = {51, -24, -46, 42};
//+
Plane Surface(8) = {8};
//+
Line Loop(9) = {27, 45, -37, -47};
//+
Plane Surface(9) = {9};
//+
Line Loop(10) = {28, -48, -38, -45};
//+
Plane Surface(10) = {10};
//+
Line Loop(11) = {48, 29, -50, -39};
//+
Plane Surface(11) = {11};
//+
Line Loop(12) = {30, -52, -40, 50};
//+
Plane Surface(12) = {12};
//+
Line Loop(13) = {52, 23, -46, -41};
//+
Plane Surface(13) = {13};
//+
Line Loop(14) = {24, 20, 6, -21};
//+
Plane Surface(14) = {14};
//+
Line Loop(15) = {23, 21, 7, -22};
//+
Plane Surface(15) = {15};
//+
Line Loop(16) = {35, -14, -36, -28};
//+
Plane Surface(16) = {16};
//+
Line Loop(17) = {36, -13, -12, -31};
//+
Plane Surface(17) = {17};
//+
Line Loop(18) = {29, 32, 11, -31};
//+
Plane Surface(18) = {18};
//+
Line Loop(19) = {30, 33, 10, -32};
//+
Plane Surface(19) = {19};
//+
Line Loop(20) = {22, 8, 9, -33};
//+
Plane Surface(20) = {20};
//+
Transfinite Surface {1};
//+
Transfinite Surface {2};
//+
Transfinite Surface {3};
//+
Transfinite Surface {4};
//+
Transfinite Surface {5};
//+
Transfinite Surface {16};
//+
Transfinite Surface {17};
//+
Transfinite Surface {18};
//+
Transfinite Surface {19};
//+
Transfinite Surface {20};
//+
Transfinite Surface {15};
//+
Transfinite Surface {14};
//+
Transfinite Surface {6};
//+
Transfinite Surface {9};
//+
Transfinite Surface {10};
//+
Transfinite Surface {11};
//+
Transfinite Surface {12};
//+
Transfinite Surface {13};
//+
Transfinite Surface {8};
//+
Transfinite Surface {7};
//+
Recombine Surface {1, 5, 16, 17, 2, 6, 9, 10, 11, 18, 3, 7, 8, 13, 12, 19, 4, 14, 15, 20};
//+
Transfinite Line {37, 27, 15} = 10 Using Progression 1;
//+
Transfinite Line {38, 28, 14} = 10 Using Progression 1;
//+
Transfinite Line {43, 26, 2} = 10 Using Progression 1;
//+
Transfinite Line {44, 25, 3} = 10 Using Progression 1;
//+
Transfinite Line {42, 24, 6} = 10 Using Progression 1;
//+
Transfinite Line {41, 23, 7} = 10 Using Progression 1;
//+
Transfinite Line {39, 29, 11} = 10 Using Progression 1;
//+
Transfinite Line {40, 30, 10} = 10 Using Progression 1;
//+
Transfinite Line {1, 34, 35, 36, 12} = 40 Using Progression 1;
//+
Transfinite Line {4, 20, 21, 22, 9} = 40 Using Progression 1;
//+
Transfinite Line {5, 19, 18, 17, 16} = 40 Using Progression 1;
//+
Transfinite Line {8, 33, 32, 31, 13} = 160 Using Progression 1;
//+
Transfinite Line {47, 45, 48, 50, 52, 46, 51, 49} = 80 Using Progression 1;

//+
Extrude {0, 0, 0.005} {
  Surface{1}; Surface{2}; Surface{3}; Surface{4}; Surface{5}; Surface{9}; Surface{6}; Surface{7}; Surface{8}; Surface{14}; Surface{16}; Surface{10}; Surface{11}; Surface{12}; Surface{13}; Surface{15}; Surface{17}; Surface{18}; Surface{19}; Surface{20}; Layers{1}; Recombine;
}

//+
Physical Surface("inlet") = {61, 83, 105, 127};
//+
Physical Surface("outlet") = {421, 443, 465, 487};
//+
Physical Surface("top") = {73, 149, 285, 417};
//+
Physical Surface("bottom") = {131, 267, 399, 483};
//+
Physical Surface("front") = {74, 162, 294, 426, 96, 118, 140, 272, 404, 492, 470, 448, 206, 228, 250, 382, 360, 338, 316, 184};
//+
Physical Surface("back") = {17, 18, 19, 20, 15, 14, 4, 3, 2, 1, 16, 5, 10, 11, 12, 13, 8, 7, 6, 9};
//+
Physical Surface("cylinderwalls") = {179, 311, 201, 227, 337, 355, 381, 249};
//+
Physical Volume("internal") = {1, 2, 3, 4, 5, 11, 17, 6, 7, 12, 13, 8, 9, 14, 15, 10, 16, 18, 19, 20};
