import csv
import matplotlib.pyplot as plt

##---------------------------------------------------------------------------##
##---------------------------------------------------------------------------##

def csvparsing(xf, a, b, c):
    x = [];
    y = [];
    z = [];
    with open(xf) as File:  
        reader = csv.reader(File)
        for row in reader:
            x.append(row[a])
            y.append(row[b])
            z.append(row[c])
    xFinal = [float(i) for i in x[1::]]
    yFinal = [float(i) for i in y[1::]]
    zFinal = [float(i) for i in z[1::]]
    
    return xFinal,yFinal,zFinal

##---------------------------------------------------------------------------##
    
shearHaFile = ['data/H'+str(i)+'/shear.csv' for i in [0,10,20,30]]
axialHaFile = ['data/H'+str(i)+'/axial.csv' for i in [0, 10, 20, 30]]
radialHaFile = ['data/H'+str(i)+'/radial.csv' for i in [0, 10, 20, 30]]
axialReFile = ['data/Re'+str(i)+'/axial.csv' for i in [50,100,150]]
radialReFile = ['data/Re'+str(i)+'/radial.csv' for i in [50,100,150]]
radialGridFile = ['data/ReGI'+str(i)+'/radial.csv' for i in [1,2]]
axialGridFile = ['data/ReGI'+str(i)+'/axial.csv' for i in [1,2]]

##---------------------------------------------------------------------------##

colour = ['k','b','g','r']

legendRe = ['$Re = 50$', '$Re = 100$', '$Re = 150$']
legendHa = ['$Ha = 0$', '$Ha = 10$', '$Ha = 20$', '$Ha = 30$' ]
legendG = ['Grid1', 'Grid2' ,'Grid3']

fileData = {
  "radialFile" : {
    "xlabelname" : "r'Velocity, $\mathbf{m/s}$'",
    "ylabelname" : "r'Width of the channel, $\mathbf{m}$'"
  },
  "axialFile" : {
    "xlabelname" : "r'Axial length of the channel, $\mathbf{m}$'",
    "ylabelname" : "r'Pressure, $\mathbf{N/m^2}$'"
  },
  "shearFile" : {
    "xlabelname" : "r'Axial length of the channel, $\mathbf{m}$'",
    "ylabelname" : "r'Wall shear stress, $\mathbf{N/m^2}$'"
  }
} 

##---------------------------------------------------------------------------##

def plotting(file, filename, ap, bp, cp, legendp):
    
    plt.figure()
    
    if legendp == "Re":
        legend = legendRe
    elif legendp == "G":
        legend  = legendG
    else:
        legend = legendHa
        
    for i,j,k in zip(file, colour,legend): 
        
        plt.plot(csvparsing(i, ap, bp, cp)[0], csvparsing(i, ap, bp, cp)[1],
                 '.-',color = j, label=k)
        plt.legend()
        if i == file[-1]:
            plt.xlabel(eval(fileData[filename]["xlabelname"]), 
                       fontsize=12 ,fontweight='bold')
            plt.ylabel(eval(fileData[filename]["ylabelname"]), 
                       fontsize=12 ,fontweight='bold')
            
            plt.xticks(size = 12)
            plt.yticks(size = 12)
            plt.grid("true")
            plt.tight_layout()
            plt.show()
        else:
            continue
 
##---------------------------------------------------------------------------##
##---------------------------------------------------------------------------##
            
plotting(shearHaFile, "shearFile", 0, 1, 1, "Ha")

plotting(axialGridFile, "axialFile", 14, 15, 10, "G")
plotting(radialGridFile, "radialFile", 10, 14, 15, "G")

plotting(axialHaFile, "axialFile", 14, 15, 10, "Ha")
plotting(radialReFile, "radialFile", 10, 14, 15, "Re")

plotting(radialHaFile, "radialFile", 10, 14, 15, "Ha")
plotting(axialReFile, "axialFile", 14, 15, 10, "Re")

##---------------------------------------------------------------------------##
    