import numpy as np
from matplotlib import pyplot as plt
import csv
with open('pressuredrop.csv') as csvfile:
    readCSV = csv.reader(csvfile, delimiter=',')
    next(readCSV)
    p=[];Ux=[];Uy=[];Uz=[];l=[];usq=[];vsq=[];wsq=[];P=[]

    for row in readCSV:     

                    
            p=np.append(p,row[0])
	    Ux=np.append(Ux,row[1])
	    Uy=np.append(Uy,row[2])
            Uz=np.append(Uz,row[3])
            l=np.append(l,row[5])
U = [float(i) for i in Ux]
V = [float(j) for j in Uy]
W = [float(k) for k in Uz]
l = [float(m) for m in l]

def Reverse(lst): 
    return [ele for ele in reversed(lst)]

P = [float(m) for m in p]
P = Reverse(P)
usq = [x**2 for x in U]
vsq = [y**2 for y in V]
wsq = [z**2 for z in W]

#Umag= [sum(x) for x in zip(usq, vsq, wsq)]

f=0.0309  #Darcy Friction factor for Re = 10,000 from Moody chart
rho=1000.0 #Density of Water
d=0.05  #Diameter of pipe
velocity=0.2 
factor=((f*rho*velocity*velocity)/(2*d))/(rho)  #we are dividing by rho for consistency, since in OpenFOAM incompressible solver, pressure is divided by density
result = [x * factor for x in l]


result = Reverse(result)


plt.figure(1)
plt.plot(l, result, 'k.:',label='Analytical')
plt.plot(l, P, 'r.:',label='OpenFOAM')
legend = plt.legend(loc='upper right', shadow=True)
plt.ylabel('$\Delta p$')
plt.xlabel('Length of the pipe')
plt.grid('on')
plt.title('Pressure Drop along the length of the pipe')
plt.savefig('Pressure_drop_comparison.eps')
plt.show()




